;================================================

;================================================
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 

begin
;************************************************
; open file and read in data
;************************************************

;*************************
  geof1  = addfile("/home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_em.d01.nc","r")
  lat1_sim   = geof1->XLAT_M
  lon1_sim   = geof1->XLONG_M
  lat1=lat1_sim(0,:,0)
  lon1=lon1_sim(0,0,:)

  plot=new(2,graphic)
  plot_t=new(2,graphic)
  plot1=new(6,graphic)
  plot_t1=new(6,graphic)
  print("hello")

loc=wrf_user_ll_to_ij(geof1, (/78,146/), (/25,51/), True)
Xstart=loc(0,0)
Xend=loc(0,1)
Ystart=loc(1,0)
Yend=loc(1,1)
;************************************************
wks = gsn_open_wks("png","S_chenyu_zoom")     ; open a workstation

;========================================


path=" /home/user/chensy3/data/zhangyue/WPSV391_2020-03/geo_2020_03/"
filename="geo_em.d01*.nc"
outfiles=systemfunc("ls " +path+filename)
f=addfiles(outfiles+".nc","r")
ListSetType(f,"join")
var = wrf_user_getvar(f(:),"EROD",-1)
printVarSummary(var)

    
;=======================================
  res                = True
  res@gsnDraw     = False
  res@gsnFrame    = False                        
  res@Footer = False
  res@InitTime    = False
  res@FieldTitle=""
  res@NoHeaderFooter           = True            ; Switch headers and footers off

  res@cnLineLabelsOn       = False
  res@cnFillOn              = True            ; color plot desired
  res@cnLinesOn             = False
  ;res@pmLabelBarWidthF = 0.9
  ;res@pmLabelBarHeightF=0.3 
  ;res@lbLabelFontHeightF    =0.025  
  res@lbLabelBarOn=False 

;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  resg=res
  resg@cnFillPalette="WhiteYellowOrangeRed";用该色板填色
  resg@cnLevelSelectionMode ="ExplicitLevels"
  resg@cnLevels=(/0.01,0.1,0.2,0.3,0.35,0.4,0.45/)
  ;resg@cnFillColors = (/0,50,66,82,98,114,146,162/)
   
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;
  resd=res
  resd@cnFillPalette="temp_diff_18lev";"nrl_sirkes";"BlueDarkRed18"
  resd@cnLevelSelectionMode ="ExplicitLevels" 
  resd@cnLevels = (/-0.2,-0.15,-0.1,-0.05,-0.02,-0.01,0.01,0.02,0.05,0.1,0.15,0.2/)
  ;resd@cnFillColors = (/3,4,5,6,7,8,0,13,14,15,16,17,18/)


  map_res = True
  map_res@gsnDraw=False
  map_res@gsnFrame=False
  map_res@mpDataSetName  = "/home/data/data-CSR4/chenyu/mapdata/Earth..4"
  map_res@mpDataBaseVersion="MediumRes"
  map_res@mpOutlineOn = True
  map_res@mpAreaMaskingOn       = True
  ;map_res@mpMaskAreaSpecifiers  = (/"China:states"/)
  ;map_res@mpOutlineSpecifiers = (/"China:states"/)
  map_res@mpNationalLineColor        = "black"
  map_res@mpCountyLineColor      = "black"
  map_res@mpProvincialLineColor  ="black"
  map_res@mpGeophysicalLineColor="black"
  map_res@mpGeophysicalLineThicknessF =1.5
 ;map_res@mpProvincialLineThicknessF = 2.
  ;map_res@mpGeophysicalLineThicknessF=2.
  map_res@mpNationalLineThicknessF=1.5
   map_res@tmXBLabelFontHeightF=0.025
  map_res@tmYLLabelFontHeightF=0.025
  map_res@tmBorderThicknessF=3

  ;限制wrfout的输出区域
  map_res@ZoomIn=True
  map_res@Xstart=Xstart
  map_res@Xend=Xend
  map_res@Ystart=Ystart
  map_res@Yend=Yend

  pltres=True
  pltres@PanelPlot = True      ; Indicate these plots are to be paneled.



  var1=var(0,0,0,:,:)-var(1,0,0,:,:)+var(1,0,0,:,:)
  plot_t(0)=wrf_contour(geof1,wks,var1(Ystart:Yend,Xstart:Xend),resg)
  plot(0) = wrf_map_overlays(geof1,wks,(/plot_t(0)/),pltres,map_res)

  var2=var(1,0,0,:,:)-var(0,0,0,:,:)+var(0,0,0,:,:)
  plot_t(1)=wrf_contour(geof1,wks,var2(Ystart:Yend,Xstart:Xend),resg)
  plot(1) = wrf_map_overlays(geof1,wks,(/plot_t(1)/),pltres,map_res)

  vard1=var(1,0,0,:,:)-var(0,0,0,:,:)
  plot_t1(0)=wrf_contour(geof1,wks,vard1(Ystart:Yend,Xstart:Xend),resd)
  plot1(0) = wrf_map_overlays(geof1,wks,(/plot_t1(0)/),pltres,map_res)

  vard2=var(2,0,0,:,:)-var(1,0,0,:,:)
  plot_t1(1)=wrf_contour(geof1,wks,vard2(Ystart:Yend,Xstart:Xend),resd)
  plot1(1) = wrf_map_overlays(geof1,wks,(/plot_t1(1)/),pltres,map_res)

  vard3=var(3,0,0,:,:)-var(1,0,0,:,:)
  plot_t1(2)=wrf_contour(geof1,wks,vard3(Ystart:Yend,Xstart:Xend),resd)
  plot1(2) = wrf_map_overlays(geof1,wks,(/plot_t1(2)/),pltres,map_res)

  vard4=var(4,0,0,:,:)-var(1,0,0,:,:)
  plot_t1(3)=wrf_contour(geof1,wks,vard4(Ystart:Yend,Xstart:Xend),resd)
  plot1(3) = wrf_map_overlays(geof1,wks,(/plot_t1(3)/),pltres,map_res)

  vard5=var(5,0,0,:,:)-var(1,0,0,:,:)
  plot_t1(4)=wrf_contour(geof1,wks,vard5(Ystart:Yend,Xstart:Xend),resd)
  plot1(4) = wrf_map_overlays(geof1,wks,(/plot_t1(4)/),pltres,map_res)

  vard6=var(6,0,0,:,:)-var(1,0,0,:,:)
  plot_t1(5)=wrf_contour(geof1,wks,vard6(Ystart:Yend,Xstart:Xend),resd)
  plot1(5) = wrf_map_overlays(geof1,wks,(/plot_t1(5)/),pltres,map_res)

  shp1="/home/user/chensy3/csr4/chenyu/NCL/china/mygeodata/china.shp"
  lnres1        = True
  lnres1@gsLineColor      ="black"
  lnres1@gsLineThicknessF = 1.5          ; 2x thickness
  shp_plot1     = gsn_add_shapefile_polylines(wks,plot(0),shp1,lnres1)
  shp_plot2     = gsn_add_shapefile_polylines(wks,plot(1),shp1,lnres1)
  shp_plot3     = gsn_add_shapefile_polylines(wks,plot1(0),shp1,lnres1)
  shp_plot4     = gsn_add_shapefile_polylines(wks,plot1(1),shp1,lnres1)
  shp_plot5     = gsn_add_shapefile_polylines(wks,plot1(2),shp1,lnres1)
  shp_plot6     = gsn_add_shapefile_polylines(wks,plot1(3),shp1,lnres1)
  shp_plot7     = gsn_add_shapefile_polylines(wks,plot1(4),shp1,lnres1)
  shp_plot8     = gsn_add_shapefile_polylines(wks,plot1(5),shp1,lnres1)

;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::;
pres                  = True
;pres@gsnMaximize=True
pres@gsnFrame         = False

pres@gsnPanelScalePlotIndex	= 0
pres@gsnPanelYWhiteSpacePercent = 0
pres@gsnPanelXWhiteSpacePercent = 0

;pres@gsnPanelFigureStrings = (/"STA","DYN","DYN-STA","(a)","(b)","(c)","(d)","(e)"/)
pres@gsnPanelFigureStringsFontHeightF = 0.015
pres@amOrthogonalPosF    =-0.5
pres@amParallelPosF      =-0.5
pres@amJust = "TopLeft"
;pres@gsnPanelRowSpec=True
pres@gsnPanelCenter=True
pres@gsnPanelLabelBar=True
pres@lbBoxSeparatorLinesOn=False

pres1=pres
pres1@gsnPanelBottom=.52
pres1@gsnPanelFigureStrings = (/"STA","DYN"/)

pres2=pres
pres2@gsnPanelTop=.8
pres2@gsnPanelRight=0.99
pres2@gsnPanelFigureStrings = (/"DYN-STA","(a)","(b)","(c)","(d)","(e)"/)
gsn_panel(wks,plot,(/1,3/),pres1)
print("hello")
gsn_panel(wks,plot1,(/2,3/),pres2)
frame(wks)
exit

end
